Option Explicit
Const scriptName = "Fix Graphic Scales"
Const scriptVer = "1.0.0"

' Revision History

' 1.0.0 - October 29, 2002 - MJM - Inital version.

' Script constants, questions, and error messages.
Const errInvalidSelection = "This script requires selected graphic elements."


' Enums
Const crElmGraphic = 1197688172


' Main

Dim CreatorApp
Set CreatorApp = WScript.CreateObject("Creator.Application")
'Set CreatorApp = GetObject(,"Creator.Application")

CreatorApp.Visible = True

Dim didSomething
didSomething = False
    
Dim continueOn
continueOn = False
        
Dim sel
Err.Clear
On Error Resume Next
Dim numItems
Set sel = CreatorApp.Selection
numItems = sel.Count
continueOn = (Err = 0 And numItems > 0)
On Error GoTo 0

If continueOn Then
    Dim anElement
    Dim itsScale
    Dim averageScale
    For Each anElement In sel
        If anElement.Class = crElmGraphic Then
            didSomething = True
            itsScale = anElement.Scale
            averageScale = (itsScale(0) + itsScale(1)) / 2
            itsScale(0) = averageScale
            itsScale(1) = averageScale
            anElement.Scale = itsScale
        End If
    Next
End If
        
If Not didSomething Then
    Call MsgBox(errInvalidSelection, vbOkonly, scriptName)
End If

